//Seuraavassa otetaan System.Text-kirjasto, josta
//StringBuilder-luokka lytyy.
using System;
using System.IO;
using System.Text;

class Esimerkki10_10
{
    static void Main(string[] args)
    {
        //Seuraavassa mritelln StringBuilder-olio, jonka 
        //sislt myhemmin ksitelln StringReader- ja
        //StringWriter-olioiden avulla.
        StringBuilder tekstiPuskuri = new StringBuilder();

        //Tss luodaan StringWriter-olio StringBuilder-olion 
        //ymprille.
        StringWriter sWriter = new StringWriter(tekstiPuskuri);

        //Tss kirjoitetaan tekstipuskuriin.
        sWriter.WriteLine(DateTime.Now);
        sWriter.WriteLine("On pilvist.");
        sWriter.WriteLine("Sataa lunta.");
        sWriter.WriteLine("Sataa rnt.");
        sWriter.WriteLine("Sataa vett.");
        sWriter.WriteLine("On aurinkoista.");

        //Tss StringWriter suljetaan.
        sWriter.Close();

        //Tss tulostetaan mrnpn nimi.
        Console.WriteLine("Tekstipuskurin koko on " +
        sWriter.GetStringBuilder().Length + ":");

        //Tss luodaan StringReader -olio StringBuilder-olion 
        //ymprille.
        StringReader sReader =
        new StringReader(tekstiPuskuri.ToString());

        //Tss tekstipuskurin sislt luetaan sisalto 
        //-merkkijonoon ja tulostetaan nytlle.
        string sisalto = sReader.ReadToEnd();
        Console.WriteLine(sisalto);

        //Tss sReader -olio alustetaan uudelleen. Tmn 
        //jlkeen sen osoitin viittaa sen alkuun edellisen 
        //ReadToEnd() -metodin kutsun jlkeen.  
        sReader = new StringReader(tekstiPuskuri.ToString());

        //Tss tekstipuskurin ensimminen rivi luetaan 
        //ja tulostetaan.
        Console.WriteLine("Ensimminen rivi: " +
        sReader.ReadLine());

        //Seuraavassa tekstipuskurista luetaan yksi merkki 
        //meotdilla Peek(), joka ei siirr virran osoitinta  
        //eteenpin. Tm tarkoittaa, ett kun seuraavan kerran  
        //luetaan virrasta, luku alkaa metodin Peek()  
        //palauttamasta merkist!
        Console.WriteLine("Peek() -metodin lukema merkki: " +
        (char)sReader.Peek());

        //Tss tekstipuskurista luetaan yksi merkki ja 
        //tulostetaan.
        Console.WriteLine("Read() -metodin lukema merkki: " +
        (char)sReader.Read());

        char[] puskuri = new char[32];

        //Tss luetaan 32 merkki puskurista 
        //puskuri -taulukkoon.
        sReader.ReadBlock(puskuri, 0, puskuri.Length);

        Console.WriteLine("32 merkki tekstipuskurista: ");
        foreach (char ch in puskuri)
            Console.Write(ch);

        Console.WriteLine();

        sReader.Close();
    }
}
