//Seuraavassa otetaan serialisoinnin vaatimat 
//Serialization- ja Binary- luokat kyttn.

using System;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;


//Seuraavassa mritelln Tuote -luoka, joka merkitn
//serialisoitavaksi.
[Serializable]
class Tuote
{
    string nimi;
    int maara;
    float yksikkoHinta;

    //Tss mritelln luokan muodostin.
    public Tuote(string nimi, int maara, float yksikkoHinta)
    {
        this.nimi = nimi;
        this.maara = maara;
        this.yksikkoHinta = yksikkoHinta;
    }

    //Tss mritell readOnly KokonaisHinta -ominaisuus.
    public float KokonaisHinta
    {

        get
        {
            return (maara * yksikkoHinta);
        }

    }

    //Tss mritelln luokan ToString() -metodi.
    public override string ToString()
    {

        return nimi + " " + maara + " " + yksikkoHinta;
    }
}

class Esimerkki10_11
{
    static void Main(string[] args)
    {
        //Tss mritelln tiedoston sijainti.
        string tiedosto = "C:\\Temp\\Sekalaisia\\tuotteet.dat";

        //Tss luodaan FileStream -olio, jonka avulla
        //serialisointi suoritetaan.
        FileStream fOutStream = File.OpenWrite(tiedosto);

        //Tss luodaan BinaryFormatter-olio, jolla serialisointi tapahtuu.
        BinaryFormatter bFormatter = new BinaryFormatter();

        //Seuraavassa luodaan tuotteet -taulukko, jossa 
        //silytetn tuotteiden tiedot.
        Tuote[] tuotteet = new Tuote[3];

        tuotteet[0] = new Tuote("Omena", 100, 1.58f);
        tuotteet[1] = new Tuote("Viiniryple", 32, 5.5f);
        tuotteet[2] = new Tuote("Vesimeloni", 50, 1.5f);

        //Seuraavassa Tuote -oliot kirjoitetaan tiedostoon.
        for (int i = 0; i < tuotteet.Length; i++)
            bFormatter.Serialize(fOutStream, tuotteet[i]);

        //Tss tiedot kirjoitetaan lopullisesti tiedostoon.
        fOutStream.Flush();

        //Tss virta suljetaan.
        fOutStream.Close();

        //Tss mritelln lukuvirta.
        FileStream fInStream = File.OpenRead(tiedosto);

        Console.WriteLine("Tuotteet tiedostossa: ");

        //Seuraavassa mritelln apumuuttujat.
        Tuote tuote = null;
        float kokonaisHinta = 0.0f;

        //Tss kydn fInStream -lukuvirta kydn lpi. 
        //Huomaa, kuinka (fInStream.Position != fInStream.Length)
        //-ehdon avulla tarkistetaan kuinka ollaan psty tiedoston
        //loppuun.
        while (fInStream.Position != fInStream.Length)
        {
            //Tss luodaan oliot kerrallaan ja tallennetaan
            //tuote -olioon, joka on tyyppi Tuote. Koska 
            //Deserialize() -metodi palauttaa object -olioita, 
            //joudutaan suorittamaan tyyppimuunnos!
            tuote = (Tuote)(bFormatter.Deserialize(fInStream));

            //Tss lasketaan tuotteiden kokonaishinta.
            kokonaisHinta += ((Tuote)tuote).KokonaisHinta;

            //Tss tuotteeiden tiedot tulostetaan. Huomaa, ett
            //tss automaattisesti kutsutaan olion ToString() -metodia.
            Console.WriteLine(tuote);

        };

        //Tss tuotteiden kokonaishinta tulostetaan nytlle.
        Console.WriteLine("Tuotteiden kokonaishinta on: " + kokonaisHinta);

        //Tss suljetaan lukuvirta.
        fInStream.Close();


    }
}