  //Seuraavassa mm. serialisoinnin vaatimat Serialization-
  //ja Soap-kirjastot otetaan kyttn.
  using System;
  using System.Collections;
  using System.IO;
  using System.Runtime.Serialization;
  using System.Runtime.Serialization.Formatters.Soap;

  //Seuraavassa mritelln luokka Tuote, joka merkitn
  //serialisoitavaksi.
  [Serializable]
  class Tuote
  {
    string nimi;
    int maara;
    float yksikkoHinta;
    
    //Tss mritelln luokan muodostin.
    public Tuote(string nimi, int maara, float yksikkoHinta)
    {
      this.nimi = nimi;
      this.maara = maara;
      this.yksikkoHinta = yksikkoHinta;
    }

    //Tss mritell lukuominaisuus KokonaisHinta.
    public float KokonaisHinta
    {
      get
      {
        return (maara * yksikkoHinta);
      }
    }
    
    //Tss mritelln luokan ToString()-metodi.
    public override string ToString()
    {
      return nimi + " " + maara + " " + yksikkoHinta;
    }
  }

  class Esimerkki10_12
  {
    static void Main(string[] args)
    {
      //Tss mrtn tiedoston sijainti.
      string tiedosto = "C:\\Temp\\Sekalaisia\\tuotteet.xml";

      //Tss luodaan FileStream-olio, jonka avulla
      //serialisointi suoritetaan.
      FileStream fOutStream = File.Open(tiedosto, 
      FileMode.Create, FileAccess.Write);

      //Tss luodaan SoapFormatter-olio, jolla 
      //serialisointi tapahtuu.
      SoapFormatter sFormatter = new SoapFormatter();

      //Seuraavassa luodaan ArrayList-kokoelma tuotteet, 
      //johon tuotteet listn.
      ArrayList tuotteet = new ArrayList();

      tuotteet.Add(new Tuote("Suklaa", 28, 16.60f));
      tuotteet.Add(new Tuote("Kahvi", 23, 9.8f));
      tuotteet.Add(new Tuote("Murot", 15, 7.75f));

      //Tss tuotteet-kokoelma kirjoitetaan tiedostoon.
      sFormatter.Serialize(fOutStream, tuotteet);

      //Tss FileStream-kirjoitusvirta suljetaan.
      fOutStream.Close();

      //Tss mritelln FileStream-lukuvirta.
      FileStream fInStream = File.OpenRead(tiedosto);

      Console.WriteLine("Tuotteet tiedostossa: ");

      //Seuraavassa mritelln apumuuttujat.
      ArrayList tuoteLista = null;
      object obj;
      float kokonaisHinta = 0.0f;

      //Seuraavassa fInStream -lukuvirta kydn lpi. 
      //Huomaa, ett (fInStream.Position != fInStream.Length)
      //-ehdon avulla tarkistetaan ollaanko psty tiedoston
      //loppuun.
      while (fInStream.Position != fInStream.Length)
      {
        //Tss luetaan tiedoston sislt object-oliona.
        obj = sFormatter.Deserialize(fInStream);
        
        //Seuraavassa tarkistetaan onko obj-olio 
        //muunnettavissa tyyppiin ArrayList. Jos on, se 
        //ensin muunnetaan ArrayList-tyyppiseksi ja 
        //sitten kopioidaan muuttujaan tuoteLista.
        if(obj is ArrayList)
          tuoteLista = (ArrayList) obj;
          
        //Tss varmistetaan, ett tuoteLista-olio ei ole
        //null ennen sen lpikynti
        if (tuoteLista != null)
        {
          //Tss tuoteLista -kokoelma kydn olio 
          //kerrallaan lpi. Huomaa, ett ArrayList-
          //kokoelmasta sislt luetaan object-olioina. 
          foreach (Object t in tuoteLista)
          {
            //Seuraavassa lasketaan tuotteiden kokonaishinta.
            //Huomaa, ett seuraavassa ensin t -oliolle 
            //suoritetaan tyyppimuunnos ja sen jlkeen 
            //kutsutaan sen KokonaisHinta -ominaisuus. 
            kokonaisHinta += ((Tuote)t).KokonaisHinta;

            //Tss tuotteeiden tiedot tulostetaan. Huomaa, 
            //ett tss automaattisesti kutsutaan olion 
            //ToString() -metodi.
            Console.WriteLine(t);
          }
        }
        else
        {
          Console.WriteLine("Tiedostossa ei ole ArrayList-dataa!");
        }
      }
      
      //Tss tuotteiden kokonaishinta tulostetaan nytlle.
      Console.WriteLine("Tuotteiden kokonaishinta on {0,5:f2} euroa. ", kokonaisHinta);
      
      //Tss suljetaan lukuvirta.
      fInStream.Close();
    }
  }
