using System;
using System.IO;

class Esimerkki10_8
{
    static void Main(string[] args)
    {
        //Tss mritelln tiedoston sijainti.
        string tiedosto = "C:\\Temp\\Sekalaisia\\tuotteet.dat";

        //Tss luodaan kirjoitusvirta (outputstream), jonka 
        //avulla mys luodaan uusi tyhj tiedosto.
        FileStream fOutStream = File.Create(tiedosto);

        //Tss luodaan BinaryWriter-virta FileStream virran 
        //ymprille.
        BinaryWriter bWriter = new BinaryWriter(fOutStream);

        //Seuraavassa luodaan tuotteiden tiedot.
        string[] nimet = { "Leip", "Voi", "Maito" };
        Int16[] maarat = { 10, 8, 12 };
        decimal[] yksikkoHinnat = { 4.56m, 5.45m, 1.10m };

        //Seuraavassa tuotteiden tiedot kirjoitetaan tiedostoon.
        for (int i = 0; i < nimet.Length; i++)
        {
            bWriter.Write(nimet[i]);
            bWriter.Write(maarat[i]);
            bWriter.Write(yksikkoHinnat[i]);
        }

        //Tss data kirjoitetaan pysyvsti tiedostoon ja 
        //BinaryWriter-virta suljetaan. Huomaa, ett ilman
        //tt BinaryReader-olio ei pysty ksittelemn 
        //tiedostoa!
        bWriter.Flush();
        bWriter.Close();

        //Tss luodaan lukuvirta (inputstream), joka viittaa 
        //fyysiseen tiedostoon.
        FileStream fInStream = File.OpenRead(tiedosto);

        //Tss mritelln apumuuttujia.
        decimal temp = 0.0m, sum = 0.0m, keskiHinta = 0.0m;

        //Tss luodaan BinaryReader-virta. 
        BinaryReader bReader = new BinaryReader(fInStream);

        Console.WriteLine("Tuotteiden tiedot: ");

        //Seuraavassa tuotteiden tiedot luetaan tiedostosta ja
        //tulostetaan nytlle.
        for (int i = 0; i < nimet.Length; i++)
        {
            //Tss luetaan tuotteen nimi ja tulostetaan nytlle.
            Console.Write(bReader.ReadString() + " ");

            //Tss luetaan tuotteen mr ja tulostetaan nytlle.
            Console.Write(bReader.ReadInt16() + " ");

            //Tss luetaan tuotteen yksikkhinta ja viedn 
            //muuttujaan temp.
            temp = bReader.ReadDecimal();

            //Muuttuja temp tulostetaan nytlle.
            Console.Write(temp + "\n");

            sum += temp;
        }

        //Tss lasketaan tuotteiden keskihinta.
        keskiHinta = sum / nimet.Length;

        //Tss tulostetaan keskiHinta
        Console.WriteLine("Tuotteiden keskihinta on {0, 5:f2}.",
        keskiHinta);

        //Tss suljetaan BinaryReader -virta.
        bReader.Close();
    }
}

