using System;
using System.IO;

class Esimerkki10_9
{
    static void Main(string[] args)
    {
        //Tss mritelln tiedoston sijainti.
        string tiedosto = "C:\\Temp\\Sekalaisia\\tuotteet.txt";

        //Tss luodaan kirjoitusvirta (outputstream) kirjoutusta
        //varten siten, ett tiedoston vanha sislt silytetn.
        FileStream fOutStream = File.Open(tiedosto,
        FileMode.Append, FileAccess.Write);

        //Tss luodaan StreamWriter-virta FileStream-virran 
        //ymprille.
        StreamWriter sWriter = new StreamWriter(fOutStream);

        //Seuraavassa kirjoitetaan pivmr tiedostoon.
        sWriter.WriteLine(DateTime.Now);

        //Seuraavassa luodaan tuotteiden tiedot.
        string[] nimet = { "Leip", "Voi", "Maito" };
        Int16[] maarat = { 10, 8, 12 };
        decimal[] yksikkoHinnat = { 4.56m, 5.45m, 1.10m };

        //Seuraavassa tuotteiden tiedot kirjoitetaan tiedostoon.
        for (int i = 0; i < nimet.Length; i++)
            sWriter.WriteLine(nimet[i] + " " + maarat[i] + " " +
            yksikkoHinnat[i]);

        //Tss data kirjoitetaan pysyvsti tiedostoon ja 
        //StreamWriter-virta suljetaan. Huomaa, ett ennen
        //seuraava lausetta StreamReader-virta ei pysty 
        //ksittelemn tiedostoa!
        sWriter.Flush();
        sWriter.Close();

        //Tss luodaan lukuvirta (inputstream), joka viittaa 
        //fyysiseen tiedostoon.
        FileStream fInStream = File.OpenRead(tiedosto);

        //Tss luodaan StreamReader-virta. 
        StreamReader sReader = new StreamReader(fInStream);

        string rivi = null;
        while ((rivi = sReader.ReadLine()) != null)
        {
            //Tss etsitn pivmr ja tulsotetaan erikseen.
            if (rivi.IndexOf(':') != -1)
                Console.WriteLine("Seuraavat tiedot on listty " +
                rivi);
            else
                Console.WriteLine(rivi);
        }

        //Tss suljetaan StreamReader-virta.
        sReader.Close();
    }
}
