using System;

//Seuraavassa mritelln liittym IRobotti.
public interface IRobotti
{
    //Tss esitelln liittymn metodit
    void Aloita();
    void Lopeta();

    //Tss esitelln ominaisuus RobottiToiminnassa.
    bool RobottiToiminnassa
    {
        get;
    }
}

//Seuraavassa mritelln luokka Robotti.
public class Robotti : IRobotti
{
    //Tss mritelln robottiToiminnassa-kentt, jota
    //liittymn RobottiToiminnassa-property kytt. 
    private bool robottiToiminnassa = false;

    //Seuraavassa toteutetaan liittymn Aloita()-metodi.
    //Huomaa, ett metodin saantimreen pit olla public. 
    public void Aloita()
    {
        robottiToiminnassa = true;
        Console.WriteLine("Robotti aloittaa toiminnan...");
    }

    //Seuraavassa toteutetaan liittymn Lopeta()-metodi. 
    //Huomaa, ett metodin saantimreen pit olla public! 
    public void Lopeta()
    {
        Console.WriteLine("Robotti lopettaa toiminnan...");
        robottiToiminnassa = false;
    }

    //Seuraavassa toteutetaan RobottiToiminnassa-property.  
    //Huomaa, ett property:n saantimreen pit olla public!
    public bool RobottiToiminnassa
    {
        get
        {
            return robottiToiminnassa;
        }
    }
}

class Esimerkki8_1
{
    static void Main(string[] args)
    {
        //Tss luodaan robotti-olio.
        Robotti robotti = new Robotti();

        //Tss kutsutaan RobottiToiminnassa-property.
        Console.WriteLine("Robotti toiminnassa: " +
        robotti.RobottiToiminnassa);

        //Seuraavassa kutsutaan olion metodit.
        robotti.Aloita();

        //Tss kutsutaan RobottiToiminnassa-property.
        Console.WriteLine("Robotti toiminnassa: " +
        robotti.RobottiToiminnassa);

        robotti.Lopeta();

        //Tss kutsutaan RobottiToiminnassa-property.
        Console.WriteLine("Robotti toiminnassa: " +
        robotti.RobottiToiminnassa);
    }
}
