  using System;

  //Seuraavassa mritelln liittym IRobotti.
  public interface IRobotti
  {
    //Tss esitelln liittymn metodit.
    void Aloita();
    void Lopeta();

    //Tss esitelln ominaisuus RobottiToiminnassa.
    bool RobottiToiminnassa
    {
      get;
    }
  }

  //Seuraavassa mritelln liittym IAlustus.
  public interface IAlustus
  {
    //Tss esitelln liittymn metodit
    void AsetaAloitusPiste(int x, int y);
    void AsetaLopetusPiste(int x, int y);
  }

  //Seuraavassa mritelln liittym IMatka.
  public interface IMatka
  {
    //Tss esitelln liittymn Matka-property.
    double Matka
    {
      get;
    }
  }

  //Seuraavassa mritelln luokka Robotti.
  public class Robotti : IAlustus, IRobotti, IMatka
  {
    //Tss esitelln muuttujat aloitus- ja lopetuspisteen 
    //x ja y koordinaatteja varten.
    private int aloitusPisteX, aloitusPisteY;
    private int lopetusPisteX, lopetusPisteY;

    //Tss mritelln robottiToiminnassa-kentt, jota
    //IRobotti-liittymn RobottiToiminnassa-property kytt. 
    private bool robottiToiminnassa = false;

    //Tss mritelln matka-kentt, jota
    //IMatka-liittymn Matka-property kytt. 
    private double matka = 0.0;

    //Seuraavassa mritelln liittymn IAlustus metodit.
    public void AsetaAloitusPiste(int x, int y)
    {
      aloitusPisteX = x;
      aloitusPisteY = y;
    }

    public void AsetaLopetusPiste(int x, int y)
    {
      lopetusPisteX = x;
      lopetusPisteY = y;
    }

    //Seuraavassa mritelln liittymn IRobotti metodit.
    //Huomaa, ett metodien saantimreiden pit olla public! 
    public void Aloita()
    {
     robottiToiminnassa = true;
     Console.WriteLine("Robotti aloittaa pisteest (" + 
     aloitusPisteX + "," + aloitusPisteY + ")");
    }
    
    public void Lopeta()
    {
     robottiToiminnassa = false;

     Console.WriteLine("Robotti pyshtyy pisteeseen: (" 
     + lopetusPisteX + "," + lopetusPisteY + ")");
  
     //Tss lasketaan robotin kuljettama matka. Matkan 
     //laskemiseksi kytetn C#:n Math-luokan kuuluvia 
     //Sqrt() ja Pow() metodeja. 
     matka = Math.Sqrt(Math.Pow((lopetusPisteX - 
     aloitusPisteX), 2.0) + Math.Pow((lopetusPisteY - 
     aloitusPisteY), 2.0));
    }
  
    //Seuraavassa toteutetaan RobottiToiminnassa-property.  
    //Huomaa, ett property:n saantimreen pit olla public!
    public bool RobottiToiminnassa
    {
     get
     {
       return robottiToiminnassa;
     }
    }
  
    //Seuraavassa mritelln IMatka-liittymn Matka 
    //-property.
    public double Matka
    {
     get
     {
       return matka;
     }
    }
  }
  
  class Esimerkki8_2
  {
    static void Main(string[] args)
    {
  
     //Tss luodaan robotti-olio.
     Robotti robotti = new Robotti();
  
     //Seuraavassa alustetaan robotti-olio.
     robotti.AsetaAloitusPiste(10, 5);
     robotti.AsetaLopetusPiste(54, 98);
  
     //Tss kutsutaan RobottiToiminnassa property.
     Console.WriteLine("Robotti on toiminnassa: " + 
     robotti.RobottiToiminnassa);
  
     robotti.Aloita();
  
     Console.WriteLine("Robotti on toiminnassa: " + 
     robotti.RobottiToiminnassa);
  
     robotti.Lopeta();
  
     Console.WriteLine("Robotti on toiminnassa: " + 
     robotti.RobottiToiminnassa);
  
     //Tss kutsutaan robotin Matka-property.
     Console.WriteLine("Robotin kuljettama matka: {0,7:f2} cm ", robotti.Matka);
    }
  }
