  using System;

  //Seuraavassa mritelln liittym IRobotti.
  public interface IRobotti
  {
    //Tss esitelln liittymn metodit.
    void Aloita();
    void Lopeta();

    //Tss mritelln ominaisuus RobottiToiminnassa.
    bool RobottiToiminnassa
    {
      get;
    }
  }

  //Seuraavassa mritelln liittym IAlustus.
  public interface IAlustus
  {
    //Tss esitelln liittymn metodit
    void AsetaAloitusPiste(int x, int y);
    void AsetaLopetusPiste(int x, int y);
  }

  //Seuraavassa mritelln luokka Matka.
  public class Matka
  {
    //Tss esitelln muuttujat aloitus- ja lopetuspisteen 
    //x ja y koordinaatteja varten. Huomaa, ett niiden 
    //saantimreeksi on asetettu protected periytymist 
    //varten.
    protected int aloitusPisteX, aloitusPisteY;
    protected int lopetusPisteX, lopetusPisteY;

    //Tss mritelln Laskematka()-metodi, joka laskee 
    //matkan aloitus- ja lopetuspisteiden perusteella.
    public double Laskematka()
    {
      //Tss lasketaan kahden pisteen vlinen matka. Matkan 
      //laskemiseksi kytetn C#:n Math luokan kuuluvia 
      //Sqrt() ja Pow() metodeja. 
      return Math.Sqrt(Math.Pow((lopetusPisteX - 
      aloitusPisteX), 2.0) + Math.Pow((lopetusPisteY -
      aloitusPisteY), 2.0));
     }
  }

  //Seuraavassa mritelln luokka Robotti, joka perii 
  //Matka-luokkaa ja toteuttaa liittymt IAlustus ja IRobotti.  
  public class Robotti : Matka, IAlustus, IRobotti 
  {
    //Tss mritelln robottiToiminnassa-kentt, jota
    //IRobotti-liittymn RobottiToiminnassa-property kytt. 
    private bool robottiToiminnassa = false;

    //Seuraavassa mritelln liittymn IAlustus metodit.
    public void AsetaAloitusPiste(int x, int y)
    {
      aloitusPisteX = x;
      aloitusPisteY = y;
    }

    public void AsetaLopetusPiste(int x, int y)
    {
      lopetusPisteX = x;
      lopetusPisteY = y;
    }

    //Seuraavassa mritelln liittymn IRobotti metodit.
    //Huomaa, ett metodin sntimreen pit olla public! 
    public void Aloita()
    {
      robottiToiminnassa = true;
      Console.WriteLine("Robotti aloittaa pisteest (" + 
      aloitusPisteX + "," + aloitusPisteY + ")");
    }
    
    public void Lopeta()
    {
      robottiToiminnassa = false;
      
      Console.WriteLine("Robotti pyshtyy pisteeseen: (" + 
      lopetusPisteX + "," + lopetusPisteY + ")");
    }

    //Seuraavassa toteutetaan RobottiToiminnassa property.  
    //Huomaa, ett property:n saantimreen pit olla public!
    public bool RobottiToiminnassa
    {
      get
      {
         return robottiToiminnassa;
      }
    }
  }
  
  class Esimerkki8_3
  {
    static void Main(string[] args)
    {
      //Tss luodaan robotti-olio.
      Robotti robotti = new Robotti();

      //Seuraavassa alustetaan robotti-olio.
      robotti.AsetaAloitusPiste(0, 0);
      robotti.AsetaLopetusPiste(30, 45);

      //Tss kutsutaan RobottiToiminnassa property
      Console.WriteLine("Robotti on toiminnassa: " + 
      robotti.RobottiToiminnassa);

      robotti.Aloita();

      Console.WriteLine("Robotti on toiminnassa: " + 
      robotti.RobottiToiminnassa);

      robotti.Lopeta();

      Console.WriteLine("Robotti on toiminnassa: " + 
      robotti.RobottiToiminnassa);

      //Tss kutsutaan Laskematka(), joka on periytynyt 
      //Matka luokasta.
      Console.WriteLine("Robotin kuljettama matka: {0,7:f2} cm ", robotti.Laskematka());
    }
  }
