  using System;

  //Seuraavassa mritelln liittym IRobotti.
  public interface IRobotti
  {
    //Seuraavassa esitelln liittymn metodit.
    void Aloita();
    void Lopeta();

    //Tss mritelln RobottiToiminnassa ominaisuus.
    bool RobottiToiminnassa
    {
      get;
    }
  }

  //Seuraavassa mritelln liittym IPyori.
  public interface IPyori
  {
    void Pyori(double kulma);
  }

  //Seuraavassa mritelln luokka Robotti, joka perii 
  //liittymn IRobotti.  
  public class Robotti : IRobotti
  {
    //Tss mritelln kentt robottiToiminnassa, jota
    //IRobotti-liittymn RobottiToiminnassa-property kytt. 
    private bool robottiToiminnassa = false;

    //Seuraavassa mritelln IRobotti liittymn metodit.
    //Huomaa, ett metodien saantimreiden pit olla public!
    public void Aloita()
    {
      robottiToiminnassa = true;
      Console.WriteLine("Robotti aloittaa toiminnan...");
    }
    
    public void Lopeta()
    {
      robottiToiminnassa = false;
      Console.WriteLine("Robotti lopettaa toiminnan...");
    }

    //Seuraavassa toteutetaan RobottiToiminnassa property.  
    //Huomaa, ett property:n saantimreen pit olla public!
    public bool RobottiToiminnassa
    {
      get
      {
        return robottiToiminnassa;
      }
    }
  }
  
  class Esimerkki8_4  
  {
    static void Main(string[] args)
    {
      //Tss luodaan robotti-olio.
      Robotti robotti = new Robotti();

      //Tss tarkisteen tukeeko robotti IRobotti liittym. 
      if (robotti is IRobotti)
         Console.WriteLine("robotti-olio tukee liittym IRobotti");
      else
         Console.WriteLine("robotti-olio ei tue liittym IRobotti ");

      //Tss tarkisteen tukeeko robotti IPyori liittym. 
      if(robotti is IPyori)
         Console.WriteLine("robotti-olio tukee liittym IPyori ");
      else
         Console.WriteLine("robotti-olio ei tue liittym IPyori ");
         
      //Tss yritetn muuntaa robotti IPyori-tyypiseksi.
      IPyori  iPyoriRobotti = robotti as IPyori;
      
      if (iPyoriRobotti != null)
      {
         //Jos iPyoriRobotti ei ole null, IPyori-liittymst 
         //periytyv Pyori()-metodi kutsutaan.
         iPyoriRobotti.Pyori(45.0);
      }
      else
      {
         Console.WriteLine("robotti-oliota ei voi muuntaa iPyoriRobotti:ksi");
      }
    }
  }
