using System;

//Seuraavassa mritelln liittym IAlustus.
public interface IAlustus
{
    //Tss esitelln liittymn metodit.
    void AsetaAloitusPiste(int x, int y);
    void AsetaLopetusPiste(int x, int y);
}

//Seuraavassa mritelln liittym IPyori.
public interface IPyori
{
    void Pyori(double kulma);
}

//Seuraavassa mritelln liittym IRobotti, 
//joka perii liittymt IAlustus ja IPyori.
public interface IRobotti : IAlustus, IPyori
{
    //Tss esitelln liittymn metodit.
    void Aloita();
    void Lopeta();

    //Tss esitelln ominaisuus RobottiToiminnassa.
    bool RobottiToiminnassa
    {
        get;
    }
}

//Seuraavassa mritelln luokka Robotti, joka perii 
//liittymn IRobotti. Huomaa, ett koska IRobotti perii
//liittymn IPyori, luokan Robotti tulee toteuttaa mys
//liittymn IPyori metodit.   
public class Robotti : IRobotti
{
    //Tss mritelln kentt robottiToiminnassa, jota
    //IRobotti-liittymn RobottiToiminnassa-property kytt. 
    private bool robottiToiminnassa = false;

    //Seuraavassa mritelln metodit AsetaAloitusPiste ja 
    //AsetaLopetusPiste, jotka ovat periytyneet 
    //liittymst IAlustus.
    public void AsetaAloitusPiste(int x, int y)
    {
        Console.WriteLine("Aloituspiste on ({0},{1})", x, y);
    }

    public void AsetaLopetusPiste(int x, int y)
    {
        Console.WriteLine("Lopetuspiste on ({0},{1})", x, y);
    }

    //Seuraavassa toteutetaan metodi Pyori(), joka on 
    //peiytynyt liittymst IPyori.    
    public void Pyori(double kulma)
    {
        //Tss radiaanikulma muunnteaan asteeksi.
        double aste = (kulma / Math.PI) * 180;
        if (aste < 0)
            //Seuraavassa Math.Abs(aste) palauttaa luvun aste 
            //absoluuttisen arvon. 
            Console.WriteLine("Robotti pyorii " +
            Math.Abs(aste) + " astetta mytpivn...");
        else if (aste == 0)
            Console.WriteLine("Robotin pyorimiskulma on " + aste
            + " astetta!");
        else
            Console.WriteLine("Robotti pyorii " + aste
            + " astetta vastapivn...");
    }

    //Seuraavassa toteutetaan liittymn IRobotti metodit.
    public void Aloita()
    {
        robottiToiminnassa = true;
        Console.WriteLine("Robotti aloittaa toiminnan...");
    }

    public void Lopeta()
    {
        robottiToiminnassa = false;
        Console.WriteLine("Robotti lopettaa toiminnan...");
    }

    //Seuraavassa toteutetaan ominaisuus RobottiToiminnassa.
    public bool RobottiToiminnassa
    {
        get
        {
            return robottiToiminnassa;
        }
    }
}

//Seuraavassa mritelln ohjelman pluokka.
class Esimerkki8_5
{
    static void Main(string[] args)
    {
        //Tss luodaan robotti-olio.
        Robotti robotti = new Robotti();

        //Tss mritelln robotin pyrimiskulma.
        double pyorimisKulma = -Math.PI / 4;

        int aloitusPisteX = 10, aloitusPisteY = 30;
        int lopetusPisteX = 450, lopetusPisteY = 320;

        robotti.Aloita();

        //Tss kutsutaan IAlustus-liittymn 
        //metodi AsetaAloitusPiste(), joka periytyy 
        //luokkaan Robotti liittymn IRobotti kautta.
        robotti.AsetaAloitusPiste(aloitusPisteX,
        aloitusPisteY);

        //Tss kutsutaan liittymn IPyori metodi Pyori(),
        //joka periytyy luokkaan Robotti liittymn IRobotti
        //kautta.
        robotti.Pyori(pyorimisKulma);

        //Tss kutsutaan liittymn IAlustus 
        //metodi AsetaLopetusPiste(), joka periytyy luokkaan 
        //Robotti liittymn IRobotti kautta.
        robotti.AsetaLopetusPiste(lopetusPisteX,
        lopetusPisteY);

        robotti.Lopeta();
    }
}
