  using System;

  //Seuraavassa mritelln liittym IRobotti.
  public interface IRobotti
  {
    //Seuraavassa esitelln liittymn metodit
    void Aloita();
    void Lopeta();

    //Seuraavassa esitelln ominaisuus RobottiToiminnassa.
    bool RobottiToiminnassa
    {
      get;
    }
  }

  //Seuraavassa mritelln liittym IVideoKamera.
  public interface IVideoKamera
  {
    //Seuraavassa esitelln liittymn metodit.
    void Aloita();
    void Lopeta();
  }

  //Seuraavassa mritelln luokka Robotti, joka 
  //toteuttaa liittymt IRobotti ja IVideoKamera. 
  public class Robotti :IRobotti, IVideoKamera
  {
    //Tss mritelln robottiToiminnassa-kentt, jota
    //IRobotti-liittymn RobottiToiminnassa-property kytt. 
    private bool robottiToiminnassa = false;

    //Seuraavassa toteutetaan liittymn IRobotti metodit 
    //eksplisiittisesti. Huomaa, kuinka liittymn nimi on
    //merkitty metodien nimen yhteydess. Huomaa, mys ett
    //saantimrett ei saa merkit eksplisiittisen 
    //toteutuksen yhteydess!
    void IRobotti.Aloita()
    {
      robottiToiminnassa = true;
      Console.WriteLine("Robotti aloittaa toiminnan...");
    }

    void IRobotti.Lopeta()
    {
      robottiToiminnassa = false;
      Console.WriteLine("Robotti lopettaa toiminnan...");
    }

    //Seuraavassa toteutetaan RobottiToiminnassa-property.  
    //Huomaa, ett tss ei ole pakko merkit liittymn 
    //nime koska luokkaan ei periydy muita samannimis 
    //ominiaisuuksia.
    public bool RobottiToiminnassa
    {
      get
      {
        return robottiToiminnassa;
      }
    }

    //Seuraavassa mritelln liittymn IVideoKamera 
    //metodit. Huomaa, ettei tss saa merkit liittym 
    //IVideoKamera.
    public void Aloita()
    {
       Console.WriteLine("Videokamera aloittaa toiminnan...");
    }

    public void Lopeta()
    {
      Console.WriteLine("Videokamera lopettaa toiminnan...");
    }
  }

  //Seuraavassa mritelln ohjelman pluokka.
  class Esimerkki8_6  
  {
    static void Main(string[] args)
    {
      //Tss luodaan robotti olio.
      Robotti robotti = new Robotti();

      //Tss kutsutaan IVideoKamera liittymn Aloita() 
      //metodi.
      robotti.Aloita();

      //Tss kutsutaan IVideoKamera liittymn Lopeta() 
      //metodi.
      robotti.Lopeta();

      //Koska IRobotti liittymn metodit toteutettiin 
      //eksplisiittisesti, robotti olio pit ensin muuntaa 
      //IRobotti liittymksi, mink jlkeen pystytn 
      //kutsumaan IRobotti liittymn metodit.
      IRobotti iRobotti = robotti as IRobotti;

      //Tss kutsutaan IRobotti liittymn Aloita() metodi.
      iRobotti.Aloita();

      //Tss kutsutaan IRobotti liittymn RobottiToiminnassa 
      //property. Huomaa, ett koska Robotti luokassa on vain 
      //yksi RobottiToiminnassa property, se voidaan kutsua 
      //mys robotti olion kautta seuraavasti:
      //Console.WriteLine("Robotti on toiminnassa: " + 
      //robotti.RobottiToiminnassa);

      Console.WriteLine("Robotti on toiminnassa: " + 
      iRobotti.RobottiToiminnassa);
    
      //Tss kutsutaan IRobotti liittymn Lopeta() metodi.
      iRobotti.Lopeta(); 
    }
  }
