using System;

//Seuraavassa mritelln liittym IRobotti.
public interface IRobotti
{
    //Tss esitelln liittymn metodit
    void Aloita();
}

//Seuraavassa mritelln liittym IVideoKamera.
public interface IVideoKamera : IRobotti
{
    //Tss esitelln liittymn metodit
    new void Aloita();
    void Lopeta();
}

//Seuraavassa mritelln luokka Robotti, joka 
//toteuttaa liittymn IVideoKamera.  
public class Robotti : IVideoKamera
{
    //Seuraavassa mritelln liittymst IRobotti 
    //perisin oleva metodi Aloita() eksplisiittisesti.
    void IRobotti.Aloita()
    {
        Console.WriteLine("Robotti aloittaa toiminnan...");
    }

    //Seuraavassa toteutetaan liittymn IVideoKamera metodi 
    //Aloita(). Huomaa, ettei tss saa merkit liittymn
    //IVideoKamera nime.
    public void Aloita()
    {
        Console.WriteLine("Videokamera aloittaa toiminnan...");
    }

    //Seuraavassa toteutetaan liittymn IVideoKamera 
    //metodi Lopeta().
    public void Lopeta()
    {
        Console.WriteLine("Videokamera lopettaa toiminnan...");
    }
}

//Seuraavassa mritelln ohjelman pluokka.
class Esimerkki8_7
{
    static void Main(string[] args)
    {
        //Tss luodaan robotti-olio.
        Robotti robotti = new Robotti();

        //Tss kutsutaan liittymn IVideoKamera 
        //metodi Aloita().
        robotti.Aloita();

        //Koska liittymn IRobotti  metodit toteutettiin 
        //eksplisiittisesti, robotti-olio pit ensin muuntaa 
        //IRobotti-tyyppiseksi, mink jlkeen liittymst
        //IRobotti periytyvt metodit pystytn kutsumaan.
        IRobotti iRobotti = robotti as IRobotti;

        //Tss kutsutaan liittymst IRobotti periytyv 
        //metodi Aloita().
        iRobotti.Aloita();

        //Tss kutsutaan liittymst IVideoKamera periytyv
        //metodi Lopeta().
        robotti.Lopeta();


       
    }
}
