 //ArrayList-luokan kytt varten otetaan
 //kyttn System.Collections-kirjasto.
 using System;
 using System.Collections;
   
 //Seuraavassa mritelln luokka Henkilo, joka toteuttaa
 //liittymn IComparable. Tm on pakollinen jos halutaan
 //pysty lajittelemaan ArrayList-kokoelman Henkilo-olioita.
 class Henkilo : IComparable
 {
   string nimi;
   int id;
   float palkka;

   public Henkilo(string nimi, int id, float palkka)
   {
     this.nimi = nimi;
     this.id = id;
     this.palkka = palkka;
   }
   
   public override string ToString()
   {
     return id + " " + nimi + " " + palkka;
   }

   //Seuraavassa toteutetaan IComparable-liittymn metodi
   //CompareTo(), joka kutsutaan aina, kun oliot lajitellaan. 
   public int CompareTo(Object obj)
   {
     //Tss joudutaan muuntamaan obj-olio Henkilo-
     //tyyppiseksi. Tm on mahdollista, koska obj on 
     //tyyppi Object, joka on kaikkien luokkien kantaluokka.
     Henkilo tempHenkilo = (Henkilo) obj;
     
     if (this.palkka < tempHenkilo.palkka)
       return -1;
     else if (this.palkka > tempHenkilo.palkka)
       return 1;
     else
       return 0;
   }
 }

 class Esimerkki9_2
 {
   static void Main(string[] args)
   {
     //Tss luodaan ArrayList-kokoelma henkilot. 
     ArrayList henkilot = new ArrayList();

     //seuraavassa mritelln Henkilo-olioita.
     Henkilo h1 = new Henkilo("Pessi", 100, 4234.50f);
     Henkilo h2 = new Henkilo("AnnaLiisa", 200, 1234.60f);
     Henkilo h3 = new Henkilo("Illuusia", 300, 3234.70f);

     //Seuraavassa listn dataa ArrayList-kokoelmaan.
     henkilot.Add(h1);
     henkilot.Add(h2);
     henkilot.Add(h3);

     Console.WriteLine("Henkiltiedot alussa:");

     //Seuraavassa ArrayList-kokoelman kaikki alkiot 
     //tulostetaan nytlle kyttmll liittym
     //IEnumerator.
     IEnumerator enumarator = henkilot.GetEnumerator();
     while (enumarator.MoveNext())
        Console.WriteLine(enumarator.Current);
        
     Console.WriteLine("-----------------");

     //Seuraavassa selvitetn sisltk 
     //ArrayList-kokoelma henkilot oliota h2.
     if (henkilot.Contains(h2))
     {
       //Tss selvitetn h2-olion indeksi.
        int h2Indeksi = henkilot.IndexOf(h2);
        Console.WriteLine("h2-olion indeksi on " +
        h2Indeksi);
        Console.WriteLine("h2: " + 
        henkilot[h2Indeksi]);
     }

     Console.WriteLine("-----------------");

     //Tss haetaan h3-olio metodin BinarySearch() avulla.
     int h3Indeksi = henkilot.BinarySearch(h3);
     Console.WriteLine("h3-olion indeksi on " + 
     h3Indeksi);
     Console.WriteLine("-----------------");

     //Tss ArrayList-kokoelman sislt lajitellaan 
     //palkan mukaan nousevaan jrjestykseen.
     henkilot.Sort();

     Console.WriteLine("Henkiltiedot nousevassa jrjestyksess palkan mukaan:");

     //Tss lpikyntifunktio enumerator 
     //alustetaan uudelleen.
     enumarator = henkilot.GetEnumerator();

     //Seuraavassa kydn luettelo lpi ja kaikki 
     //alkiot taas tulostetaan nytlle. 
     while (enumarator.MoveNext())
        Console.WriteLine(enumarator.Current);

     Console.WriteLine("-----------------");

     //Tss ArrayList-kokoelman henkilot sislt 
     //lajitellaan palkan mukaan laskevaan jrjestykseen.
     henkilot.Reverse();

     Console.WriteLine("Henkiltiedot laskevassa jrjestyksess palkan mukaan:");

     //Tss ArrayList-kokoelman henkilot kaikki alkiot 
     //taas tulostetaan nytlle. Huomaa, ett tss 
     //taulukon sislt kydn indeksin avulla lpi.
     for (int i = 0; i < henkilot.Count; i++)
        Console.WriteLine(henkilot[i]);

     Console.WriteLine("-----------------");

     //Tss poistetaan kokoelman henkilot kaikki alkiot.
     henkilot.Clear();

     Console.WriteLine("Henkiliden lukumr Clear() metodin kutsun jlkeen:");

     //Tss taas tulostetaan taulukon alkioiden lukumr.
     Console.WriteLine("henkilot.Count=" + 
     henkilot.Count);
   }
 }
