//ArrayList-luokan kytt varten otetaan 
//kyttn System.Collections-kirjasto.
using System;
using System.Collections;

//Tss mritelln luokka Henkilo, joka toteuttaa
//liittymn IComparable. Tm on pakollinen jos halutaan
//pysty lajittelemaan ArrayList-kokoelman Henkilo-olioita.
class Henkilo : IComparable
{
    string nimi;
    int id;
    float palkka;

    //Tss mritelln luokalle attribuutti 
    //lajitteluKriteeti.
    public static string lajitteluKriteeti = "nimi";

    public Henkilo(string nimi, int id, float palkka)
    {
        this.nimi = nimi;
        this.id = id;
        this.palkka = palkka;
    }

    public override string ToString()
    {
        return id + " " + nimi + " " + palkka;
    }

    //Ts mritelln staattinen metodi, joka saa 
    //argumenttina ArrayList-kokoelman ja tulostaa sen 
    //sislln nytlle.
    public static void TulostaHenkilot(ArrayList henkilot)
    {
        //Seuraavassa ArrayList-kokoelman kaikki alkiot 
        //tulostetaan nytlle liittymn IEnumerator avulla.
        IEnumerator enumarator = henkilot.GetEnumerator();

        while (enumarator.MoveNext())
            Console.WriteLine(enumarator.Current);

        Console.WriteLine("-----------------");
    }

    public int VertaileID(Object obj)
    {
        //Tss joudutaan muuntamaan obj-olio Henkilo-
        //tyyppiseksi. Tm on mahdollista, koska obj on 
        //tyyppi Object, joka on kaikkien luokkien kantaluokka.
        Henkilo tempHenkilo = (Henkilo)obj;

        if (this.id < tempHenkilo.id)
            return -1;
        else if (this.id > tempHenkilo.id)
            return 1;
        else
            return 0;
    }

    public int VertaileNimi(Object obj)
    {
        //Tss joudutaan muuntamaan obj-olio Henkilo-
        //tyyppiseksi.
        Henkilo tempHenkilo = (Henkilo)obj;

        //Seuraavassa nimi-attribuutteja verrataan 
        //keskenn metodin CompareTo() avulla.
        if (this.nimi.CompareTo(tempHenkilo.nimi) < 1)
            return -1;
        else if (this.nimi.CompareTo(tempHenkilo.nimi) > 1)
            return 1;
        else
            return 0;
    }

    //Seuraavassa toteutetaan liittymn IComparable 
    //metodi CompareTo(), joka kutsutaan, kun oliot lajitellaan. 
    public int CompareTo(Object obj)
    {
        int vertailuTulos = 0;

        if (lajitteluKriteeti.Equals("nimi"))
            vertailuTulos = VertaileNimi(obj);
        else
            vertailuTulos = VertaileID(obj);

        return vertailuTulos;
    }
}

class Esimerkki9_3
{
    static void Main(string[] args)
    {
        //Tss luodaan henkilot ArrayList
        ArrayList henkilot = new ArrayList();

        //seuraavassa mritelln Henkilo olioita.
        Henkilo h1 = new Henkilo("Pessi", 100, 4234.50f);
        Henkilo h2 = new Henkilo("AnnaLiisa", 300, 1234.60f);
        Henkilo h3 = new Henkilo("Illuusia", 200, 3234.70f);

        //Seuraavassa listn dataa ArrayList-kokoelmaan
        henkilot.Add(h1);
        henkilot.Add(h2);
        henkilot.Add(h3);

        Console.WriteLine("Henkiltiedot alussa:");

        //Tss kutsutaan TulostaHenkilot staattinen metodi, 
        //joka saa argumenttina ArrayList-kokoelman.
        Henkilo.TulostaHenkilot(henkilot);

        //Tss lajitteluKriteeti attribuutin arvoksi laitetaan
        //"nimi", eli Henkilo oliot lajitellaan niiden nimi 
        //attribuutin perusteella.
        Henkilo.lajitteluKriteeti = "nimi";

        //Tss ArrayList-kokoelman sislt lajitellaan 
        //palkan mukaan nousevaan jrjestykseen.
        henkilot.Sort();

        Console.WriteLine("Henkiltiedot jrjestyksess "
        + Henkilo.lajitteluKriteeti + "-attribuutin mukaan:");

        //Tss tulostetaan ArrayList-kokoelman henkilot sislt.
        Henkilo.TulostaHenkilot(henkilot);

        //Tss lajitteluKriteeti attribuutin arvoksi 
        //laitetaan "nimi", eli Henkilo oliot lajitellaan niiden
        //nimi attribuutin perusteella.
        Henkilo.lajitteluKriteeti = "id";

        //Tss ArrayList-kokoelman sislt lajitellaan palkan 
        //mukaan nousevaan jrjestykseen.
        henkilot.Sort();

        Console.WriteLine("Henkiltiedot jrjestyksess "
        + Henkilo.lajitteluKriteeti + "-attribuutin mukaan:");

        //Tss taas tulostetaan henkilot-ArrayList tauluko
        //sislt.
        Henkilo.TulostaHenkilot(henkilot);
    }
}
