  using System;
  using System.Collections;
  
  //Seuraavassa mritelln luokka TeleAlue.
  class TeleAlue
  {
    string nimi; 
    int asukasLKM;
    
    public TeleAlue(string nimi, int asukasLKM)
    {
     this.nimi = nimi;
     this.asukasLKM = asukasLKM;
    } 

    public override string ToString()
    {
     return nimi + ", " + asukasLKM;
    }
  }
  
  class Esimerkki9_6
  {
    static void Main(string[] args)
    {
     //Tss luodaan lajiteltu lista suuntaNumerot.
     SortedList suuntaNumerot = new SortedList();

     //Seuraavassa listn alkioita lajiteltuun listaan. 
     //Huomaa, ett arvot ovat luokan TeleAlue olioita.
     suuntaNumerot.Add("06", new TeleAlue("Vaasan telealue", 
     50000));
     suuntaNumerot.Add("08", new TeleAlue("Oulun telealue", 
     30000));
     suuntaNumerot.Add("03", new TeleAlue("Hmeen telealue", 
     500000));

     //Tss listan alkioiden lukumr tulostetaan nytlle.
     Console.WriteLine("Alkioiden lukumr listassa: " + 
     suuntaNumerot.Count);

     //Seuraavassa listan alkiot tulostetaan nytlle. 
     IDictionaryEnumerator dictEnumerator = 
     suuntaNumerot.GetEnumerator();
     
     while (dictEnumerator.MoveNext())
      Console.WriteLine(dictEnumerator.Key + "-->" + 
      dictEnumerator.Value);

     //Seuraavassa metodilla ContainsKey() tarkistetaan 
     //lytyyk hakuavain "06" listassa.
     bool loytynyt = suuntaNumerot.ContainsKey("06");
     Console.WriteLine("06 suuntanumero lytyy listasta? " 
     + loytynyt);

     //Tss selvitetn avaimen "08" indeksi ja se 
     //tulostetaan nytlle.
     Console.WriteLine("08 suuntanumeron indeksi listassa: " 
     + suuntaNumerot.IndexOfKey("08"));
     
     //Tss selvitetn avaimen "02" indeksi ja se 
     //tulostetaan nytlle. Huomaa, ett jos 
     //hakuavainta ei lydy, metodi palauttaa -1.
     Console.WriteLine("02 suuntanumeron indeksi listassa: " 
     + suuntaNumerot.IndexOfKey("02"));

     Console.WriteLine("Telealueiden nimet listassa: ");
     //Seuraavassa ensin suuntaNumerot listan arvot 
     //kopioidaan ICollection olioon, josta sitten 
     //alkiot luetaan IEnumerator oliolla ja tulostetaan
     //nytlle.

     //Tss saadaan kokoelma listan arvoista (values).
     ICollection teleAlueet = suuntaNumerot.Values;

     //Tss luodaan IEnumerator olio GetEnumerator() 
     //metodilla. 
     IEnumerator enumerator = teleAlueet.GetEnumerator();

     //Tss luettelon alkiot tulostetaan nytlle.
     while (enumerator.MoveNext())
      Console.Write("'" + enumerator.Current.ToString() +
      "' ");

     Console.WriteLine();

     //Tss listan 0 indeksin arvo muokataan. Huomaa, 
     //kuinka 0 indeksiss olevan arvoksi luodaan uusi 
     //TeleAlue luokka.
     suuntaNumerot.SetByIndex(0, new TeleAlue("Uusi Hmeen telealue",45000));
     
     Console.WriteLine("Lista 0 indeksin alkio muutoksen jlkeen:");
     //Tss listan 0 indeksin alko tulostetaan nytlle.
     Console.WriteLine(suuntaNumerot.GetKey(0) + "-->" + 
     suuntaNumerot.GetByIndex(0));

     //Tss '06' suuntanumero poistetaan listasta.
     suuntaNumerot.Remove("06");

     //Tss luodaan lista kokoelman avaimista.
     IList hakuAvainLista = suuntaNumerot.GetKeyList();

     //Tss luodaan lista kokoelman arvoista.
     IList arvoLista = suuntaNumerot.GetValueList();

     Console.WriteLine("Listan sislt 06 suuntanumeron poiston jlkeen:");

     //Tss avinListan ja arvoListan sisllt 
     //tulostetaan nytlle.
     for (int i = 0; i < hakuAvainLista.Count; i++)
      Console.WriteLine(hakuAvainLista[i] + " " + 
      arvoLista[i]);
    }
  } 
